// MainHook.cpp : Defines the entry point for the DLL application.
//


#include "stdafx.h"
#include "MainHook.h"
#include "WINUSER.H"    //contains all these constants, structs, etc...



//-------------------------
// Global Variables
//-------------------------
HANDLE	hInstance;				// Global instance handle for	DLL
HHOOK	hHooks;				// Hook handle


//-------------------------
// Shared DATA
//-------------------------
#pragma data_seg("SHARDATA")
#pragma data_seg()



//-------------------------
// DLL Code
//-------------------------
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	hInstance = hModule;

	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}



//-------------------------------
// This is an exported function
//   used to install the hook.
//-------------------------------
MAINHOOK_API int InstallFilterDLL()
{
	//It seems that the hHooks handle is different for every process.
	//  Therefore placing this var in the SHARDATA section will gpf or lock up
	//  the system because there is only 1 hHooks handle.

	hHooks = SetWindowsHookEx(WH_SYSMSGFILTER,(HOOKPROC) SysMsgProc, (HINSTANCE) hInstance, 0);

	return (int)hHooks;
}


MAINHOOK_API int UnInstallFilterDLL(void)
{
	return UnhookWindowsHookEx(hHooks);
}



//---------------------------------------------------------------------------
//
// Filter function for the WH_SYSMSGFILTER hook
//
//---------------------------------------------------------------------------
LRESULT CALLBACK SysMsgProc (int nCode, WPARAM wParam, LPARAM lParam )
{
	MSG		*lpMsg;
	lpMsg = (MSG *) lParam;

	switch (nCode)
	{
		case MSGF_DIALOGBOX:
			break;
		case MSGF_MENU:
			break;
		case MSGF_SCROLLBAR:
			break;
		default:
			break;
	}

	//Pass all messages on to the next hook in the chain
	return CallNextHookEx(hHooks, nCode, wParam, lParam);
}

